/*
	modsec2iptables
	version 1.0

	faster rewrite done by fbis.ch
*/
#include <stdio.h>
#include <syslog.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <libgen.h>

extern char *optarg;
extern int optind, opterr, optopt;

/* Blacklistdirectory
 *  Log bannend IPs to this directory
 */
#define BLACKLISTDIR "/var/lock/modsec2iptables"
/* Maximal length of the full path
 * consists of BLACKLISTDIR/blacklist-<IP>.ip
 * Change with caution
 */
#define MAXLEN 1024

/* DROP/REJECT rule in your netfilter.
 * %s is replaced by the clients IP address
 */
/*#define CMD "/sbin/iptables -I INPUT -p tcp --dport 80 -s %s -j DROP"*/
#define CMD "/sbin/iptables -A INPUT --jump REJECT -p tcp --reject-with tcp-reset -m comment --comment '\''Http DDos'\'' -m multiport --dport 80,443 -s %s"

/**/
#define VERSION 1.0

struct record {
	char ip[16];
	char filename[MAXLEN];
	time_t timestamp;
};

void usage (char *name) {
	printf ("Usage: %s [-i IP address][-n]\n", name);
	printf ("\t-n    disable reverse lookups\n");
	printf ("\t-?,-h this info\n");
	printf ("\nEXAMPLE: %s -i IP address\tban the given IP\n");
	printf ("\t\n%s version %0.2f\n", basename (name), VERSION);
	exit (0);
}

void banip (char *ip) {
	char *buf;
	buf = (char *) calloc (1024, sizeof (char));
	if (snprintf (buf, 1024, CMD, ip) >= 1024) {
		syslog (LOG_ERR, "Error: CMD string too long");
		exit (1);
	}
	/* puts (buf); */
	system (buf);
	free (buf);
}

char * extractip (char *file) {
	char *nfile = (char *) strdup (file);
	char *point = (char *) nfile;
	point += 10;
	point[strlen (point) - 3] = '\0';
	char *ip = strdup (point);
	free (nfile);
	return ip;
}

char * reverselookup (char *ip) {
	in_addr_t a = inet_addr (ip);
	struct hostent *host = gethostbyaddr (&a, sizeof (a), AF_INET);
	if (host == NULL) {
		return "-";
    }
	return host->h_name;
}

int is_ip_valid (char *ip) {
	while (*ip != 0) {
		if ((*ip != '.') && (isdigit (*ip) == 0)) {
			return 0;
		}
		ip++;
	}
	return 1;
}

int main (int argc, char **argv) {
	char *ip = NULL;
	char *blacklistfile = NULL;
	struct stat *file = NULL;
	int unban = 0;
	int status = 0;
	int nolookup = 0;

	setlogmask (LOG_UPTO (LOG_NOTICE));
	openlog ("modsec2iptables", LOG_CONS | LOG_PID | LOG_NDELAY, LOG_LOCAL1);

	setuid (0);
	seteuid (0);
	if (getuid () != 0) {
		syslog (LOG_ERR, "This binary needs r00t-privileges.");
		syslog (LOG_ERR, "Set owner to root as well as the sticky bit to it");
		exit (1);
	}

	int arg;
	while ((arg = getopt (argc, argv, "i:uns")) != -1) {
		switch (arg) {
		case 'i':
			ip = optarg;
			break;
		case 'n':
			nolookup = 1;
			break;
		case '?':
		case 'h':
			usage (argv[0]);
		}
	}

	if (ip == NULL) {
		ip = getenv ("REMOTE_ADDR");
	}

	if ((ip == NULL || !is_ip_valid (ip)) && !status) {
		syslog (LOG_ERR, "Error: Invalid IP or empty address: %s", ip);
		exit (1);
	}

	blacklistfile = (char *) calloc (MAXLEN, sizeof (char));
	if (snprintf(blacklistfile, MAXLEN, "%s/blacklist-%s", BLACKLISTDIR, ip) >= MAXLEN) {
		syslog (LOG_ERR, "Error: Filename truncated, allocate more memory");
		exit (1);
	}

	file = (struct stat *) malloc (sizeof (struct stat));
	stat (blacklistfile, file);
	int err = errno;

	/* Ban IP */
	if (err == ENOENT) {
	/* File does not exist -> blacklist the ip */
		syslog (LOG_NOTICE, "Blacklisting IP %s", ip);
		int fd = open (blacklistfile, O_CREAT | O_EXCL | O_TRUNC, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
		if (fd == -1) {
			syslog (LOG_ERR, "%s: %s (errno=%d)\n", blacklistfile, strerror (errno), errno);
		} else {
			printf("Banned %s, created %s\n", ip, blacklistfile);
		}
		close (fd);
		banip (ip);
	} else if (err == 0) {
		/* File does exist -> positive match */
		syslog (LOG_NOTICE, "Got positive match from IP %s", ip);
	} else {
		/* an error occurred, most likely No such file ... */
		syslog (LOG_ERR, "%s: %s (errno=%d)\n", blacklistfile, strerror (errno), errno);
		exit (1);
	}
	closelog ();
	return 0;
}
